# Biblical Tower of Babel Story in Its Ancient Near Eastern Context



与创世和洪水故事的情况不同，美索不达米亚的资料中**并没有为我们提供一个巴别塔的平行故事**。虽然美索不达米亚文学没有提供任何相关的平行故事，但是美索不达米亚的材料文化对于理解和解释这个引人入胜的圣经故事非常重要。

## 美索不达米亚的建筑材料

> Mesopotamian bricks were made of clay mixed with straw. 

==砖==是美索不达米亚最常见的建筑材料。美索不达米亚砖由==粘土==与==稻草==混合制成。<u>砖块在阳光下晒干</u>，然后用于建造相对简单的结构。为了建造更复杂的建筑物，比如寺庙，美索不达米亚人会<u>使用窑烤砖</u>。这种砖更耐用。然而，木柴在美索不达米亚并不是广泛存在的，所以窑烤砖的造价也更高。

用砖建造是一项很有效的技术：它充分利用了<u>美索不达米亚河流和运河中丰富的粘土</u>。美索不达米亚还拥有丰富的沥青资源。为了稳定砖建筑，美索不达米亚的建筑工程师会使用==沥青==（bitumen）。这种材料可用于建筑物，船只等的加固和密封。

在以色列的土地上，沥青是一种不常见的物质。在圣经中，沥青被称为 hemar. Hemar 一词在圣经中很少见。在除塔巴别塔的故事之外，它只出现过两次。

这两个文本都涉及以色列中心地带以外的特殊地理区域。在其中一个案例中，<u>死海地区被描述为“沥青井”（创世记14:10）</u> ——这种描述符合该地区的地质构造。

第二次提到沥青是在对摩西摇篮密封的描述（the sealing of Moses’ cradle）中。据说他的母亲用沥青密封他的"小方舟"（出埃及记2：3）。



## 以色列的建筑材料

以色列土地上最常见的建筑材料不是砖块，而是==石头==。这种差异自然取决于适当原料的可用性。以色列的山区拥有丰富的石头。

在粘合剂材料方面也存在一些差异。在以色列，粘合剂通常是==粘土==，有时也与==石灰==（lime）结合，用于加固和密封建筑物。在美索不达米亚，正如我们之前所诉，他们是使用沥青。

古代以色列很清楚美索不达米亚人的建筑方式，也明白他们之间的差别：

> And they had brick for stone, and bitumen for clay (Gen 11:3) 



## 巴别塔的背景

> Modern excavations in Mesopotamia have supplied us with a key for understanding this mysterious tower. Most probably, it should be identified with the structure known  as the **ziggurat**.  
>
> A ziggurat is a terraced step tower, similar in shape to a pyramid. Ziggurats were erected inside Mesopotamian temple complexes. 

所以，巴别塔的原型可能是美索不达米亚文明中的金字塔（Ziggurat）。这些金字塔类似于埃及金字塔，通常建在神庙群中。

金字塔一般有大约五十米高，底部大概有2000平方米。从最早的公元前2200年左右一直到公元500年，美索不达米亚地区都有建造金字塔的历史。

大多数的金字塔核心部分都是用**晒干砖**（dried bricks）建造，而它们的外层结构大多数是使用**窑烤砖**（fired bricks）。在金字塔的内部是单个很大的空间，而非是很多房间。有些金字塔可以通过外部的楼梯或者螺旋坡道到达顶部。其他的金字塔则不能上到其顶部。有些学者认为金字塔顶部是宗教圣地，但这一假说没有得到考古学结果的支持。

迄今为止，在美索不达米亚及其周边地区发现了三十多座金字塔遗迹。但都没有完全保留，保存最完好的是==the Great Ziggurat of Ur==。

对我们来说，最感兴趣的时候位于巴比伦城的金字塔，因为巴比伦在希伯来语里就是巴别（Babel）城。巴比伦城的金字塔叫做 “E-temen-an-ki”，在苏美尔语中意为 “**天堂和地狱建筑基础的房子**”。巴比伦的金字塔大约在公元前2千年末期建立，并被之后的各个巴比伦王扩建或重建。巴比伦的金字塔很有可能是在波斯帝国时代摧毁。

之后，亚历山大大帝尝试重建它。不幸的是，该项目在完成初始阶段后很快就被放弃了。之后金字塔外部的高品质砖块和瓷砖被当地人重复用于其他目的。当现代考古学家挖掘出这个遗址时，他们只找到了这个曾经壮观的金字塔的地基。

在神话 **Enuma Elish** 中，巴比伦城和它的寺庙与金字塔是在历史的开端由众神建造的。在Marduk战胜Tiamat之后，众神为了感激他希望为他建造一座神殿。Marduk 对这提议感到很高兴，并命令众神建造巴比伦。建筑花费了两年，第一年准备足够数量和质量的砖块，第二年完成神庙和金字塔建筑。

由众神建造的寺庙被称为 **Esagila** ，在苏美尔语中意为“屋顶高远的房子”。旁边的金字塔在这里被称为“Apsu Tower”。这个名字暗示巴比伦的金字塔代表了地下的淡水（Apsu ）。

W. L. Lambert 认为巴比伦神庙在 Enuma Elish 中代表着宇宙的中心，位于天堂和大地之间。

在圣经的巴别塔故事中，巴别塔的顶部被描述为可以到达天堂。这符合美索不达米亚的观念，即这个金字塔是天地之间的接触点。所以，巴别塔很可能就是巴比伦城的金字塔。



## 巴别之名

阿卡德语使用了特殊的书写系统。这个系统包括学者们所谓的**语标**（logogram）。语标是表达整个单词的标志。它通常来自该单词的图形表示。

在阿卡德语中，“巴比伦”一词的发音为 Babili。这个名字通常不是用音节书写的。相反，它是使用两个语标书写而的：一个表示“门”，第二个表示“上帝”。这种拼写方式反映了阿卡德文士如何解释城市的名称：**上帝之门**，或更好：众神之门。事实上，阿卡德语中的bab表示门，而ili表示“上帝”。

目前尚不清楚这个词源是否反映了名称的原始含义或二级解释。无论如何，它传达了巴比伦在美索不达米亚文化中的中心地位，以及它是宇宙中心的感知。

> Therefore is the name of it called Babel; because there the Lord confounded (Heb: balal) the language of the whole earth; and from there the Lord scattered them abroad upon the face of the whole earth. 

然而圣经在这里告诉我们，巴比伦的名字不应该像在美索不达米亚那样与神圣的存在联系在一起。它不是辉煌，而是意味着混乱：语言的混乱和文明的破坏。



## 美索不达米亚文化对巴别塔故事的影响

### 卡苏托的观点

一些评论家认为这个故事的目的是**模仿美索不达米亚文化**及其关于世界，神灵和人性的观点。这一观点的主要倡导者之一是卡苏托（==Cassuto==）。

卡苏托提出这种叙述是**讽刺性的**。城市和塔楼的建造代表了巴比伦居民的傲慢野心。这个城市代表着政治狂妄自大（hubris）：巴比伦人相信他们能够建立一个如此重要的城市，让全人类都能在那里生活。塔楼代表宗教狂妄自大：巴比伦人相信他们能够建造一座如此奇妙的塔楼，以便连接天地。

根据卡苏托的说法，这个故事嘲弄了巴比伦这个名字的巴比伦词源。这个故事声称巴别不是众神之门；这也不是天地相遇并连接宇宙的中心点。相反，巴别是一个分裂和混乱的地方。

> Babel is a place of schism and confusion.  

因此，卡苏托认为，以色列和美索不达米亚建筑技术之间的比较旨在嘲弄金字塔结构 - 美索不达米亚技术王冠上的宝石。根据卡苏托的说法，这个故事说明美索不达米亚的建筑材料不如以色列人使用的建筑材料。这意味着巴比伦人缺乏完成雄心勃勃计划的基本物质手段。整个建筑很可笑，因为上帝需要 “go down” 来看的清楚点。在创世纪20章中，雅各布的梦也能理解为反巴比伦。

## 其他的观点

卡苏托对巴别塔故事的解读强调了巴比伦和以色列文化之间的对比。然而，叙述也可以从其他角度来看待。一些学者提出，选择巴比伦作为故事的背景并不表示对巴比伦的任何具体偏见。相反，它反映了巴比伦是古代世界文明的象征这一事实。根据这种解释，这个故事并不是特别挑选巴比伦人，而是批评人类的傲慢。

故事的其他细节也支持这种解释。叙述描述了一个降临的事件 - 在整个世界中 - 不仅仅是一个特定的国家。事实上，故事发生在国籍和语言概念诞生之前。上帝下去看看“人类的孩子们所建造的城市和塔楼” - 而不是“巴比伦人所建造的”。这些细节似乎表明这个故事描绘了一个普遍的事件。批评的箭头是针对整个人类的。该叙述旨在警告**不存在边界的人类野心的危险**。这种情节的最佳场景是巴比伦，因为它是古代世界最强大文化之一。

==Claus Westermann== 认为美索不达米亚文化的许多细节具有中性而非具有争议性的内涵。关于美索不达米亚建筑技术的信息应该被解释为偶然的叙述。它旨在向以色列人读者介绍美索不达米亚常见的建筑技术——这些技术使他们获得了如此巨大的建筑成就。故事以奇妙和警告的声调响起：关于人类技术的警告。

同样，“巴比伦” 的词源并不一定嘲弄美索不达米亚的共同意义。它简单地描述了巴比伦如何从权力的象征沦为上帝胜过人类傲慢的象征。从这个角度来看，这个故事代表了对最强大文明的傲慢宗教的抗议。

whzecomjm
20190622